
#ifndef _1_CRYS_EXT_ATP_TST_AES_Acceptance_h_H
#define _1_CRYS_EXT_ATP_TST_AES_Acceptance_h_H



/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"


#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 30 10:18:14 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_AES_Acceptance.h#1:incl:1
   *  \author 
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
typedef struct TST_Ext_AES_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	CRYS_AES_Key_t 				TST_Key;
	CRYS_AES_KeySize_t			TST_KeySize;
	CRYS_AES_IvCounter_t		TST_IvCounter;
	DxUint8_t 					TST_input_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_output_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_Expected_output_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_dataSize;	
	CRYS_AES_OperationMode_t	TST_OperationMode;
} TST_Ext_AES_TestDataStruct;

typedef struct TST_Ext_AES_MAC_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	CRYS_AES_Key_t 				TST_Key;
	CRYS_AES_KeySize_t			TST_KeySize;
	CRYS_AES_IvCounter_t		TST_IvCounter;
	DxUint8_t 					TST_input_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_output_data[TST_AES_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_dataSize;
	DxUint8_t 					TST_Expected_CBC_MAC[TST_CBC_MAC_SIZE];
	CRYS_AES_OperationMode_t	TST_OperationMode;
} TST_Ext_AES_MAC_TestDataStruct;

typedef struct TST_AES_KeyWrap_TestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    CRYS_AES_Key_t 				TST_Key;
    CRYS_AES_KeySize_t			TST_KeySize;
    DxUint8_t 					TST_InputData[TST_AES_DATA_VEC_SIZE_IN_BYTS];
    DxUint16_t 					TST_InputDataSize;
    DxUint8_t 					TST_WrapdData[TST_AES_DATA_VEC_SIZE_IN_BYTS];
    DxUint16_t 					TST_WrapdDataSize;
    DxUint8_t 					TST_ExpectedWrapedData[TST_AES_DATA_VEC_SIZE_IN_BYTS];
    DxUint8_t 					TST_OutputData[TST_AES_DATA_VEC_SIZE_IN_BYTS];
} TST_AES_KeyWrap_TestDataStruct;

/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_AES_Acceptance_NON_integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for AES non integrated API's							
 * 	This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   - CBC/EBC/CTR  
 * 	Vector sizes used (in bytes) - 16/32/512/1536									
 * 	Key Size used (in bits)	    - 128/192/256								
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_AES_Init function to start the encryption/decryption process
 * 2. Call the CRYS_AES_Block - This function is called N times
 *                              (N = number of blocks in data each block is 16byte)
 * 3. Call the CRYS_AES_Free to end the encryption/decryption process 
 * 4. Compare the outputted result to the expected one													
 *
 ******************************************************************************/
CRYSError_t CRYS_ExtApp_ATP_AES_NON_integrated ( void );

/*****************************************************************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_AES_Acceptance_Integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for AES integrated API							
 * 	This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   - CBC/EBC/CTR  
 * 	Vector sizes used (in bytes) - 16/32/512/1536								
 * 	Key Size used (in bits)	    - 128/192/256								
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_AES function to use the AES encryption/decryption process
 * 2. Compare the outputted result to the expected one													
 *
 ******************************************************************************/	
CRYSError_t CRYS_ExtApp_ATP_AES_Integrated ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_AES_Acceptance_MAC_NON_integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   - MAC   
 *  Vector sizes used (in bytes) - 16/32/512/1536                     
 *  Key Size used (in bits)     - 128/192/256                               
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the SEPQA_AES_MAC_NON_Integrated function to use the AES encryption/decryption process
 * 2. Verify function succeded according to the returned error code                                                  
 *
 ******************************************************************************/

CRYSError_t CRYS_ExtApp_ATP_AES_Acceptance_MAC_NON_integrated ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_AES_Acceptance_XCBC_CMAC_NON_integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using AES new modes
 *  XCBC and CMAC
 *  AES modes                   - MAC   
 *  Vector sizes used (in bytes) - 16/32/512/1536                     
 *  Key Size used (in bits)     - 128/ 192 CMAC only / 256 CMAC only                              
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. call to SEPQA_AES_XCBC_CMAC_NON_integrated function                                                  
 *
 ******************************************************************************/

CRYSError_t CRYS_ExtApp_ATP_AES_Acceptance_XCBC_CMAC_NON_integrated ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_TST_AES_Acceptance_XCBC_CMAC_integrated     
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using AES new modes
 *  XCBC and CMAC
 *  AES modes                   - MAC   
 *  Vector sizes used (in bytes) -1536                     
 *  Key Size used (in bits)     - 256 CMAC only                              
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. call to SEPQA_AES_XCBC_CMAC_integrated function                                                  
 *
 ******************************************************************************/


CRYSError_t CRYS_ExtApp_ATP_AES_Acceptance_XCBC_CMAC_integrated ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_AES_Acceptance_MAC_integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using AES
 *  AES modes                   - MAC   
 *  Vector sizes used (in bytes) - 1536                     
 *  Key Size used (in bits)     -  256                               
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the SEPQA_AES_MAC_NON_Integrated function to use the AES encryption/decryption process
 * 2. Verify function succeded according to the returned error code                                                  
 *
 ******************************************************************************/

CRYSError_t CRYS_ExtApp_ATP_AES_Acceptance_MAC_integrated ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_AES_Acceptance_KeyWrapUnwarp     
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using AES
 *  
 *  Vector sizes used (in bytes) - 1536                     
 *  Key Size used (in bits)     -  256                               
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the CRYS_ExtApp_ATP_AES_Acceptance_KeyWrapUnwarp function to use the Wrap/UnWrap process
 * 2. Verify function succeded according to the returned error code                                                  
 *
 ******************************************************************************/

CRYSError_t CRYS_ExtApp_ATP_AES_Acceptance_KeyWrapUnwarp ( void );


#ifdef __cplusplus
}
#endif

#endif

